

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">All Products</h5>
                            </div>
                            <div class="d-flex gap-2 align-items-center">
                                <a href="<?php echo e(route('product-stock')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp;
                                    Purchase Products</a>
                                <a href="<?php echo e(route('product-add')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp;
                                    Add Products</a>
                                <a href="<?php echo e(route('product-import-index')); ?>" class="btn bg-gradient-primary btn-sm mb-0">Bulk
                                    Import</a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body px-0 pt-0 pb-2">

                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0 table-hover" id="myTable">
                                <thead>
                                    <tr>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Product Name</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Category</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Avl.
                                            Qty</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Price</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($product->branch->native_name_flag == 'A' ? ($product->native_name ?? $product->name) : $product->name); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($product->category->name); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($product->qty); ?></p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($product->unit_price); ?></p>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('product-edit', $product->id)); ?>">
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                
                                                <span class="ms-2">
                                                    <form action="<?php echo e(route('product-delete', $product->id)); ?>" method="POST"
                                                        class="d-inline" id="delete-form-<?php echo e($product->id); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <i class="fas fa-trash text-secondary"
                                                            onclick="confirmDelete(<?php echo e($product->id); ?>)"></i>
                                                    </form>
                                                </span>
                                            </td>
                                        </tr>                                  
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/products/index.blade.php ENDPATH**/ ?>