

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Update Payment</h5>
                            </div>
                            <span class="badge bg-primary extra_amount" style="display: none;">Extra Amount: ₹ 0.00</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('invoice-payment-update')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" value="<?php echo e($payment->id); ?>">
                            <div class="row">
                                <div class="col-lg-4 mb-4">
                                    <label for="invoice" class="form-label">Invoice:</label>
                                    <select class="form-select" id="invoice" name="invoice" disabled>
                                        <option value="<?php echo e($invoice->id); ?>" selected>
                                            <?php echo e($invoice->invoice_id); ?> - <?php echo e($invoice->client->user->phone ?? ''); ?>

                                        </option>
                                    </select>
                                    <input type="hidden" name="invoice" value="<?php echo e($invoice->id); ?>">
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="totalAmount" class="form-label">Total Amount:</label>
                                    <input type="text" id="totalAmount" class="form-control" name="totalAmount"
                                        value="<?php echo e(old('totalAmount', $invoice->final_amount)); ?>" readonly>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="dueAmount" class="form-label">Due Amount:</label>
                                    <input type="text" id="dueAmount" class="form-control" name="dueAmount"
                                        value="<?php echo e(old('dueAmount', $dueAmount)); ?>" readonly>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="paidAmount" class="form-label">Paid Amount</label>
                                    <input type="text" id="paidAmount" class="form-control" name="paidAmount"
                                        value="<?php echo e(old('paidAmount', $totalPaidAmount)); ?>" readonly>
                                </div>

                                <div class="col-lg-4 mb-4">
                                    <label for="paymentDate" class="form-label">Payment Date</label>
                                    <input type="date" id="paymentDate" class="form-control" name="paymentDate"
                                        value="<?php echo e(old('paymentDate', $payment->payment_date ?? now()->toDateString())); ?>"
                                        required>
                                    <?php $__errorArgs = ['paymentDate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="paymentMethod" class="form-label">Payment Method</label>
                                    <select name="paymentMethod" id="paymentMethod" class="form-select" required>
                                        <option value="">Select Payment Method</option>
                                        <?php $__currentLoopData = $payment_mode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['paymentMethod'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4" id="tenderedAmountContainer" style="display: none;">
                                    <label for="tendered_amount" class="form-label">Tendered Amount</label>
                                    <input type="number" step="0.01" name="tendered_amount" id="tendered_amount"
                                        class="form-control" value="<?php echo e(old('tendered_amount')); ?>"
                                        placeholder="Enter tendered amount">
                                    <?php $__errorArgs = ['tendered_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="amount" class="form-label">Amount</label>
                                    <input type="number" step="0.01" id="amount" class="form-control" name="amount"
                                        value="<?php echo e(old('amount')); ?>" required>
                                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="note" class="form-label">Note:</label>
                                    <textarea id="note" class="form-control" name="note"
                                        rows="1"><?php echo e(old('note', $payment->notes ?? '')); ?></textarea>
                                    <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="table-responsive p-0 mb-4">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                                Invoices
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                                Payment Date
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Amount
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Payment Method
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $cumulativeTotal = 0;
                                        ?>

                                        <?php $__empty_1 = true; $__currentLoopData = $paymentsForInvoice; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td class="ps-4">
                                                    <p class="text-xs font-weight-bold mb-0"><?php echo e($data->invoice->invoice_id); ?>

                                                    </p>
                                                </td>
                                                <td class="ps-4">
                                                    <p class="text-xs font-weight-bold mb-0">
                                                        <?php echo e(\Carbon\Carbon::parse($data->payment_date)->format('d/m/Y')); ?>

                                                    </p>
                                                </td>
                                                <td class="text-center">
                                                    <p class="text-xs font-weight-bold mb-0"><?php echo e($data->amount); ?></p>
                                                </td>
                                                <td class="text-center">
                                                    <p class="text-xs font-weight-bold mb-0">
                                                        <?php echo e(\App\Models\PaymentsModel::PAYMENT_MODE[$data->payment_mode] ?? 'Unknown'); ?>

                                                    </p>
                                                </td>
                                            </tr>
                                            <?php
                                                $cumulativeTotal += $data->amount;
                                            ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="5" class="text-center">
                                                    <p class="text-xs font-weight-bold mb-0">No Payments found.</p>
                                                </td>
                                            </tr>
                                        <?php endif; ?>

                                        <?php if($cumulativeTotal > 0): ?>
                                            <tr>
                                                <td colspan="2" class="text-end text-xs font-weight-bold">Total Amount:</td>
                                                <td class="text-center text-xs font-weight-bold"><?php echo e($cumulativeTotal); ?></td>
                                                <td colspan="2"></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="submit" class="btn btn-primary me-2">Update Payment</button>
                                <a href="<?php echo e(route('invoice-payment-index')); ?>" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function () {

            $('#paymentMethod').on('change', function () {
                const selectedText = $('#paymentMethod option:selected').text().toLowerCase();
                if (selectedText.includes('cash')) {
                    $('#tenderedAmountContainer').show();
                } else {
                    $('#tenderedAmountContainer').hide();
                    $('.extra_amount').hide();
                    $('#tendered_amount').val('');
                    $('#amount').val($('#amount').data('original') || 0);
                    $('.extra_amount').text('Extra Amount: ₹ 0.00');
                }
            });

            $('#amount').data('original', parseFloat($('#amount').val()) || 0);

            function calculatePaymentBreakdown() {
                let total_amount = parseFloat($('#totalAmount').val()) || 0;
                let paid_amount = parseFloat($('#paidAmount').val()) || 0;

                let tendered_amount = parseFloat($('#tendered_amount').val()) || 0;

                let remaining_amount = total_amount - paid_amount;

                let extra_amount = 0;
                let paying_amount = tendered_amount;

                if (tendered_amount > remaining_amount) {
                    extra_amount = tendered_amount - remaining_amount;
                    paying_amount = remaining_amount;
                }

                $('.extra_amount').text('Extra Amount: ₹ ' + extra_amount.toFixed(2));
                $('#amount').val(paying_amount.toFixed(2));
            }

            $(document).on('input', '#tendered_amount', calculatePaymentBreakdown);

            if ($('#tendered_amount').val()) {
                calculatePaymentBreakdown();
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/invoice-payments/edit.blade.php ENDPATH**/ ?>